

set more off
quiet: do "INDIVIDUAL 3. Merge TWM and RILA.do"


*===============================================================================
* Regressions
*===============================================================================

log using "Tables 1, S6, S7. Regression of Interfaith Attitudes.log", replace


*===========================
*TWM Survey
*===========================
set more off

** Regression of composite dependent variables
xtmixed zfac_attitudes zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith ///
				zloggdppc zrdi zGRI zpolity2 if muslim==1 || COUNTRY:
gen used_twm = e(sample)
estimates store me_facTWM

reg zfac_attitudes zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith i.COUNTRY if muslim==1
estimates store fe_facTWM


** Regression of individual dependent variables
foreach dv of varlist zson zdaughter {

	meologit `dv' zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith ///
				zloggdppc zrdi zGRI zpolity2 if muslim==1 || COUNTRY:
	estimates store me_`dv'TWM
	
	ologit `dv' zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith i.COUNTRY if muslim==1
	estimates store fe_`dv'TWM
}

meqrlogit verydifferent zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith ///
						zloggdppc zrdi zGRI zpolity2 if muslim == 1 || COUNTRY:
estimates store me_similarTWM
	
logit verydifferent zbonding1 zfreqpray zedu zage female rural zefficacy zpersonalecon favordem onetruefaith i.COUNTRY if muslim==1
estimates store fe_similarTWM


*===========================
*RILA Survey
*===========================			

** Regression of individual dependent variables
meqrlogit verydifferent zbonding1 zfreqpray zedu zage female rural zpersonalecon favordem onetruefaith ///
						zloggdppc zrdi zGRI zpolity2 if muslim == 0 || COUNTRY:
gen used_rila = e(sample)
estimates store me_similarRILA

logit verydifferent zbonding1 zfreqpray zedu zage female rural zpersonalecon favordem onetruefaith i.COUNTRY if muslim==0
estimates store fe_similarRILA

						
esttab me* using "Tables 1 and S6. Regression of Interfaith Attitudes (Mixed Effects).csv", b(3) se(2) starlevels(+ .10 * .05 ** .01 *** .001) r2(3) nogaps replace
esttab fe* using "Table S7 Regression of Interfaith Attitudes (Fixed Effects).csv", b(3) se(2) starlevels(+ .10 * .05 ** .01 *** .001) r2(3) nogaps replace
estimates clear	

tab icountry if used_twm == 1
tab icountry if used_rila == 1

log close

